//Arduino dual-Vex motor robot driver using Serial/USB
//Attach a MAX232 to the RX/TX pins on the Arduino to use RS-232 instead of USB

//Commands (4 bytes each)
//Speed Control: 255, <motor1>, <motor2>, 200
//Speed Limit Set: 254, <motor1>, <motor2>, 200
//Speed Limit Read: 253, <not used>, <not used>, 200

#include <Servo.h>
#include <EEPROM.h>

#include "WProgram.h"
void setMotor1(int m1sp);
void setMotor2(int m2sp);
void setMotors();
void setup();
void loop();
int motor1_pin = 9;
int motor2_pin = 10;
Servo motor1;
Servo motor2;

const int motor1_trim = 5; ////////////////////////////////
const int motor2_trim = 5; //Enter adjustments for motors//
int motor1_speed=90; //////////////////////////////////////
int motor2_speed=90; //Default value is 90 (stopped)//
byte motor1_limit = EEPROM.read(0);
byte motor2_limit = EEPROM.read(1);
int frame[4];

void setMotor1(int m1sp)
{
  motor1.write(m1sp+motor1_trim);
}

void setMotor2(int m2sp)
{
  motor2.write(180-m2sp+motor2_trim);
}

void setMotors()
{
  if( motor1_speed >= (90-motor1_limit) && motor1_speed <= (90+motor1_limit) )
  {
    setMotor1(motor1_speed);
  }
  else if ( motor1_speed < (90-motor1_limit) )
  {
    setMotor1(90-motor1_limit);
  }
  else if ( motor1_speed > (90+motor1_limit) )
  {
    setMotor1(90+motor1_limit);
  }
  if( motor2_speed >= (90-motor2_limit) && motor2_speed <= (90+motor2_limit) )
  {
    setMotor2(motor2_speed);
  }
  else if ( motor2_speed < (90-motor2_limit) )
  {
    setMotor2(90-motor2_limit);
  }
  else if ( motor2_speed > (90+motor2_limit) )
  {
    setMotor2(90+motor2_limit);
  }
}

void setup()
{
  motor1.attach(motor1_pin);
  motor2.attach(motor2_pin);
  setMotors();
  pinMode(13,OUTPUT);
  Serial.begin(19200);
}

void loop()
{
  digitalWrite(13,LOW);
  do
  {
    if(Serial.available() > 0)
    {
      frame[0] = Serial.read();
    }
  }while(frame[0] != 255 && frame[0] != 254 && frame[0] != 253);
  digitalWrite(13,HIGH);
  for(int i = 1; i < 4; i++)
  {
    while(Serial.available() == 0)
    {
    }
    frame[i] = Serial.read();
  }
  digitalWrite(13,LOW);
  if(frame[0] == 255 && frame[3] == 200)
  {
    motor1_speed = frame[1];
    motor2_speed = frame[2];
    setMotors();
  }
  else if(frame[0] == 254 && frame[3] == 200)
  {
    motor1_limit = frame[1];
    motor2_limit = frame[2];
    EEPROM.write(0,motor1_limit);
    EEPROM.write(1,motor2_limit);
  }
  else if(frame[0] == 253 && frame[3] == 200)
  {
    Serial.print(motor1_limit,DEC);
    Serial.print(' ');
    Serial.print(motor2_limit,DEC);
    Serial.print('\n');
  }
  Serial.flush();
  digitalWrite(13,LOW);
  frame[0] = 0; 
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

